<?php
/*
 * ÇETİNS PANEL - VERİTABANI BAĞLANTISI (system/db.php)
 * Bu dosya projenin kalbidir. Tüm sayfalar veritabanına buradan erişir.
 */

// Sunucu Ayarları (Hosting panelinden aldığın bilgiler)
$host       = 'localhost';         // Sunucu adresi (Genelde localhost)
$dbname     = 'cetinsor_proje';    // OLUŞTURDUĞUN VERİTABANI ADI (Burayı düzenle)
$username   = 'cetinsor_kullanici';  // VERİTABANI KULLANICI ADI (Burayı düzenle)
$password   = 'Sifre123!';         // VERİTABANI ŞİFRESİ (Burayı düzenle)
$charset    = 'utf8mb4';           // Türkçe karakter sorunu olmaması için

try {
    // PDO ile Güvenli Bağlantı Kuruyoruz
    // DSN (Data Source Name) oluşturuluyor
    $dsn = "mysql:host=$host;dbname=$dbname;charset=$charset";
    
    // Bağlantı seçenekleri
    $options = [
        PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION, // Hataları gizleme, göster (Geliştirme aşamasında)
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,       // Verileri dizi olarak çek
        PDO::ATTR_EMULATE_PREPARES   => false,                  // Gerçek Prepare kullanımı (Güvenlik için şart)
    ];

    // Bağlantıyı başlat
    $db = new PDO($dsn, $username, $password, $options);

    // Eğer buraya kadar hata vermediyse bağlantı başarılıdır.
    // echo "Bağlantı Başarılı"; // Test etmek istersen bu satırın başındaki // işaretlerini kaldır.

} catch (PDOException $e) {
    // Bir hata olursa (Şifre yanlışsa vs.) kod burada durur.
    // Güvenlik Notu: Canlı sitede $e->getMessage() kullanıcıya gösterilmemelidir.
    die("Veritabanı Bağlantı Hatası: Bir sorun oluştu, lütfen yöneticiyle iletişime geçin."); 
    // Geliştirme yaparken hatayı görmek için üstteki satırı silip şunu açabilirsin:
    // die("Hata: " . $e->getMessage());
}
?>