<?php
session_start();
require_once 'system/db.php';

// Güvenlik
if (!isset($_SESSION['is_logged_in']) || $_SESSION['is_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

$mesaj = "";
$mesaj_tur = "";

// AYARLARI KAYDET
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Formdan gelen verileri al
    // Checkbox işaretli değilse post edilmez, bu yüzden isset kontrolü yaparız
    $mode = isset($_POST['mode']) ? 1 : 0; 
    
    $title = trim($_POST['title']);
    $text = trim($_POST['text']);

    $sql = "UPDATE settings SET maintenance_mode = :mode, maintenance_title = :title, maintenance_text = :text WHERE id = 1";
    $stmt = $db->prepare($sql);
    $update = $stmt->execute(['mode' => $mode, 'title' => $title, 'text' => $text]);

    if ($update) {
        $mesaj = "Site modu güncellendi.";
        $mesaj_tur = "success";
    } else {
        $mesaj = "Hata oluştu.";
        $mesaj_tur = "danger";
    }
}

// Mevcut Ayarları Çek
$ayar = $db->query("SELECT * FROM settings WHERE id = 1")->fetch(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="tr" data-theme="light">
<?php include 'inc/header.php'; ?>
<body>
    <?php include 'inc/sidebar.php'; ?>
    <main class="dashboard-main">
        <?php include 'inc/navbar.php'; ?>
        
        <div class="dashboard-main-body">
            <div class="d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
                <h6 class="fw-semibold mb-0">Site Modu Ayarları</h6>
                <ul class="d-flex align-items-center gap-2">
                    <li class="fw-medium"><a href="index.php">Dashboard</a></li>
                    <li>-</li>
                    <li class="fw-medium">Site Modu</li>
                </ul>
            </div>

            <?php if($mesaj != ""): ?>
                <div class="alert alert-<?php echo $mesaj_tur; ?> d-flex align-items-center gap-2 border-0 radius-8 px-16 py-12 mb-24 shadow-sm">
                    <iconify-icon icon="lucide:check-circle" class="text-xl"></iconify-icon>
                    <p class="mb-0 text-sm"><?php echo $mesaj; ?></p>
                </div>
            <?php endif; ?>

            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="card h-100 p-0 radius-12">
                        <div class="card-header border-bottom bg-base py-16 px-24">
                            <h6 class="text-lg fw-semibold mb-0">Site Durumu</h6>
                        </div>
                        <div class="card-body p-24">
                            
                            <form action="" method="POST">
                                
                                <div class="mb-4 p-3 bg-light radius-8 border d-flex align-items-center justify-content-between">
                                    <div>
                                        <h6 class="text-md fw-bold mb-1">Siteyi Kapat (Bakım Modu)</h6>
                                        <p class="text-sm text-secondary-light mb-0">Aktif ederseniz, yöneticiler hariç kimse siteyi göremez.</p>
                                    </div>
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" name="mode" value="1" style="width: 3em; height: 1.5em;" <?php echo ($ayar['maintenance_mode'] == 1) ? 'checked' : ''; ?>>
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label text-sm fw-semibold">Başlık</label>
                                    <input type="text" name="title" class="form-control radius-8" value="<?php echo htmlspecialchars($ayar['maintenance_title']); ?>" required>
                                </div>
                                
                                <div class="mb-3">
                                    <label class="form-label text-sm fw-semibold">Açıklama Metni</label>
                                    <textarea name="text" class="form-control radius-8" rows="4"><?php echo htmlspecialchars($ayar['maintenance_text']); ?></textarea>
                                </div>

                                <button type="submit" class="btn btn-primary w-100 radius-8 py-2">
                                    <iconify-icon icon="solar:disk-outline" class="text-lg me-1 vertical-middle"></iconify-icon> Ayarları Kaydet
                                </button>
                            </form>

                        </div>
                    </div>
                </div>
            </div>

        </div>
        <?php include 'inc/copyright.php'; ?>
    </main>
    <?php include 'inc/footer.php'; ?>
</body>
</html>