<?php
// ==========================================
// 1. AYARLAR VE GÜVENLİK
// ==========================================
session_start();
require_once 'system/db.php';

// Güvenlik
if (!isset($_SESSION['is_logged_in']) || $_SESSION['is_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

$mesaj = "";
$mesaj_tur = "";

// ==========================================
// 2. FORM İŞLEMLERİ (UPDATE)
// ==========================================
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $site_title       = trim($_POST['site_title']);
    $site_desc        = trim($_POST['site_description']);
    $site_key         = trim($_POST['site_keywords']);
    $email            = trim($_POST['contact_email']);
    $phone            = trim($_POST['contact_phone']);
    $address          = trim($_POST['contact_address']);
    $footer           = trim($_POST['footer_text']);
    $facebook         = trim($_POST['facebook']);
    $instagram        = trim($_POST['instagram']);

    $sql = "UPDATE settings SET 
            site_title = :title,
            site_description = :desc,
            site_keywords = :key,
            contact_email = :email,
            contact_phone = :phone,
            contact_address = :addr,
            footer_text = :foot,
            facebook = :face,
            instagram = :insta
            WHERE id = 1";
            
    $stmt = $db->prepare($sql);
    $update = $stmt->execute([
        'title' => $site_title,
        'desc'  => $site_desc,
        'key'   => $site_key,
        'email' => $email,
        'phone' => $phone,
        'addr'  => $address,
        'foot'  => $footer,
        'face'  => $facebook,
        'insta' => $instagram
    ]);

    if ($update) {
        $mesaj = "Ayarlar başarıyla güncellendi!";
        $mesaj_tur = "success";
    } else {
        $mesaj = "Bir hata oluştu.";
        $mesaj_tur = "danger";
    }
}

// Verileri Çek
$query = $db->query("SELECT * FROM settings WHERE id = 1");
$ayar = $query->fetch(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="tr" data-theme="light">

<?php include 'inc/header.php'; ?>

<body>

    <?php include 'inc/sidebar.php'; ?>

    <main class="dashboard-main">
        
        <?php include 'inc/navbar.php'; ?>
        
        <div class="dashboard-main-body">

            <div class="d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
                <h6 class="fw-semibold mb-0">Site Ayarları</h6>
                <ul class="d-flex align-items-center gap-2">
                    <li class="fw-medium">
                        <a href="index.php" class="d-flex align-items-center gap-1 hover-text-primary">
                            <iconify-icon icon="solar:home-smile-angle-outline" class="icon text-lg"></iconify-icon>
                            Dashboard
                        </a>
                    </li>
                    <li>-</li>
                    <li class="fw-medium">Ayarlar</li>
                </ul>
            </div>

            <div class="row">
                <div class="col-lg-12">
                    
                    <?php if($mesaj != ""): ?>
                        <div class="alert alert-<?php echo $mesaj_tur; ?> px-4 py-3 mb-4 rounded-3 border-0">
                            <?php echo $mesaj; ?>
                        </div>
                    <?php endif; ?>

                    <div class="card h-100 p-0 radius-12">
                        <div class="card-header border-bottom bg-base py-16 px-24">
                            <h6 class="text-lg fw-semibold mb-0">Genel Site Bilgileri</h6>
                        </div>
                        
                        <div class="card-body p-24">
                            <form action="" method="POST">
                                <div class="row">
                                    <div class="col-md-6 mb-20">
                                        <label class="form-label fw-semibold text-primary-light text-sm mb-8">Site Başlığı</label>
                                        <input type="text" name="site_title" class="form-control radius-8" value="<?php echo htmlspecialchars($ayar['site_title']); ?>">
                                    </div>
                                    <div class="col-md-6 mb-20">
                                        <label class="form-label fw-semibold text-primary-light text-sm mb-8">E-Posta</label>
                                        <input type="email" name="contact_email" class="form-control radius-8" value="<?php echo htmlspecialchars($ayar['contact_email']); ?>">
                                    </div>
                                    <div class="col-md-6 mb-20">
                                        <label class="form-label fw-semibold text-primary-light text-sm mb-8">Telefon</label>
                                        <input type="text" name="contact_phone" class="form-control radius-8" value="<?php echo htmlspecialchars($ayar['contact_phone']); ?>">
                                    </div>
                                    <div class="col-md-6 mb-20">
                                        <label class="form-label fw-semibold text-primary-light text-sm mb-8">Footer Yazısı</label>
                                        <input type="text" name="footer_text" class="form-control radius-8" value="<?php echo htmlspecialchars($ayar['footer_text']); ?>">
                                    </div>
                                    <div class="col-md-12 mb-20">
                                        <label class="form-label fw-semibold text-primary-light text-sm mb-8">Site Açıklaması (Description)</label>
                                        <textarea name="site_description" class="form-control radius-8" rows="2"><?php echo htmlspecialchars($ayar['site_description']); ?></textarea>
                                    </div>
                                    <div class="col-md-12 mb-20">
                                        <label class="form-label fw-semibold text-primary-light text-sm mb-8">Anahtar Kelimeler</label>
                                        <input type="text" name="site_keywords" class="form-control radius-8" value="<?php echo htmlspecialchars($ayar['site_keywords']); ?>">
                                    </div>
                                    <div class="col-md-12 mb-20">
                                        <label class="form-label fw-semibold text-primary-light text-sm mb-8">Adres</label>
                                        <textarea name="contact_address" class="form-control radius-8" rows="2"><?php echo htmlspecialchars($ayar['contact_address']); ?></textarea>
                                    </div>
                                    
                                    <div class="col-12 my-3"><hr></div>
                                    
                                    <div class="col-md-6 mb-20">
                                        <label class="form-label fw-semibold text-primary-light text-sm mb-8">Facebook</label>
                                        <input type="text" name="facebook" class="form-control radius-8" value="<?php echo htmlspecialchars($ayar['facebook']); ?>">
                                    </div>
                                    <div class="col-md-6 mb-20">
                                        <label class="form-label fw-semibold text-primary-light text-sm mb-8">Instagram</label>
                                        <input type="text" name="instagram" class="form-control radius-8" value="<?php echo htmlspecialchars($ayar['instagram']); ?>">
                                    </div>

                                    <div class="col-12 mt-24 d-flex justify-content-end">
                                        <button type="submit" class="btn btn-primary px-32 py-12 radius-8">Kaydet</button>
                                    </div>
                                </div> </form>
                        </div> </div> </div> </div> </div> <?php include 'inc/copyright.php'; ?>

    </main> 
    
    <?php include 'inc/footer.php'; ?>

</body>
</html>