<?php
session_start();
require_once 'system/db.php';

if (!isset($_SESSION['is_logged_in']) || $_SESSION['is_logged_in'] !== true) {
    header("Location: login.php"); exit;
}

// SİLME İŞLEMİ
if (isset($_GET['del'])) {
    $id = intval($_GET['del']);
    $db->query("DELETE FROM pages WHERE id = $id");
    header("Location: pages.php"); exit;
}

$pages = $db->query("SELECT * FROM pages ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="tr" data-theme="light">
<?php include 'inc/header.php'; ?>
<body>
    <?php include 'inc/sidebar.php'; ?>
    <main class="dashboard-main">
        <?php include 'inc/navbar.php'; ?>
        
        <div class="dashboard-main-body">
            <div class="d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
                <h6 class="fw-semibold mb-0">Sayfalar</h6>
                <a href="page-form.php" class="btn btn-primary px-4 py-2 radius-8 d-flex align-items-center gap-2">
                    <iconify-icon icon="solar:document-add-linear" class="text-xl"></iconify-icon> Yeni Sayfa Oluştur
                </a>
            </div>

            <div class="card h-100 p-0 radius-12">
                <div class="card-body p-24">
                    <div class="table-responsive">
                        <table class="table bordered-table sm-table mb-0">
                            <thead>
                                <tr>
                                    <th>Başlık</th>
                                    <th>Link (Slug)</th>
                                    <th>Durum</th>
                                    <th class="text-end">İşlem</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach($pages as $p): ?>
                                <tr>
                                    <td class="fw-bold text-dark"><?php echo htmlspecialchars($p['title']); ?></td>
                                    <td class="text-primary-600">/<?php echo htmlspecialchars($p['slug']); ?></td>
                                    <td>
                                        <?php if($p['status'] == 'published'): ?>
                                            <span class="badge bg-success-focus text-success-main px-2 py-1 radius-4">Yayında</span>
                                        <?php else: ?>
                                            <span class="badge bg-secondary-light text-secondary-600 px-2 py-1 radius-4">Taslak</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="text-end">
                                        <a href="page-form.php?id=<?php echo $p['id']; ?>" class="w-32-px h-32-px bg-success-focus text-success-main rounded-circle d-inline-flex align-items-center justify-content-center">
                                            <iconify-icon icon="lucide:edit-2"></iconify-icon>
                                        </a>
                                        <a href="?del=<?php echo $p['id']; ?>" onclick="return confirm('Silmek istiyor musunuz?')" class="w-32-px h-32-px bg-danger-focus text-danger-main rounded-circle d-inline-flex align-items-center justify-content-center">
                                            <iconify-icon icon="mingcute:delete-2-line"></iconify-icon>
                                        </a>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <?php include 'inc/copyright.php'; ?>
    </main>
    <?php include 'inc/footer.php'; ?>
</body>
</html>