<?php
session_start();
require_once 'system/db.php';

// Güvenlik
if (!isset($_SESSION['is_logged_in']) || $_SESSION['is_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

// 1. DURUM GÜNCELLEME İŞLEMLERİ (Linkten gelen isteklere göre)
if (isset($_GET['action']) && isset($_GET['id'])) {
    $id = intval($_GET['id']);
    $action = $_GET['action'];

    if ($action == 'mark_read') {
        $db->query("UPDATE contact_messages SET is_read = 1 WHERE id = $id");
    } elseif ($action == 'mark_unread') {
        $db->query("UPDATE contact_messages SET is_read = 0 WHERE id = $id");
    } elseif ($action == 'mark_replied') {
        // Yanıtlandıysa otomatik olarak okundu da sayılır
        $db->query("UPDATE contact_messages SET is_replied = 1, is_read = 1 WHERE id = $id");
    }

    // İşlem bitince temiz URL'ye dön
    header("Location: contact-messages.php");
    exit;
}

// SİLME İŞLEMİ
if (isset($_GET['del'])) {
    $id = intval($_GET['del']);
    $db->query("DELETE FROM contact_messages WHERE id = $id");
    header("Location: contact-messages.php");
    exit;
}

// MESAJLARI ÇEK (En yeni en üstte)
$mesajlar = $db->query("SELECT * FROM contact_messages ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);

// İstatistikler
$okunmamis_sayisi = 0;
foreach($mesajlar as $m) { if($m['is_read'] == 0) $okunmamis_sayisi++; }
?>

<!DOCTYPE html>
<html lang="tr" data-theme="light">
<?php include 'inc/header.php'; ?>
<body>
    <?php include 'inc/sidebar.php'; ?>
    <main class="dashboard-main">
        <?php include 'inc/navbar.php'; ?>
        
        <div class="dashboard-main-body">
            <div class="d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
                <h6 class="fw-semibold mb-0">İletişim Mesajları</h6>
                <ul class="d-flex align-items-center gap-2">
                    <li class="fw-medium"><a href="index.php">Dashboard</a></li>
                    <li>-</li>
                    <li class="fw-medium">Gelen Kutusu</li>
                </ul>
            </div>

            <div class="card h-100 p-0 radius-12">
                <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
                    <h6 class="text-lg fw-semibold mb-0">Gelen Mesajlar</h6>
                    <div class="d-flex gap-3">
                        <span class="text-sm text-secondary-light">Toplam: <b><?php echo count($mesajlar); ?></b></span>
                        <?php if($okunmamis_sayisi > 0): ?>
                            <span class="text-sm text-danger-main fw-bold">Okunmamış: <?php echo $okunmamis_sayisi; ?></span>
                        <?php endif; ?>
                    </div>
                </div>
                
                <div class="card-body p-24">
                    
                    <div class="accordion" id="messageList">
                        <?php if(count($mesajlar) > 0): ?>
                            <?php foreach($mesajlar as $m): ?>
                            
                            <?php 
                                $bg_class = ($m['is_read'] == 0) ? 'bg-primary-50 border-primary-200' : 'bg-base border';
                                $text_weight = ($m['is_read'] == 0) ? 'fw-bold text-dark' : 'fw-medium text-secondary';
                                $icon_color = ($m['is_read'] == 0) ? 'text-primary-main' : 'text-secondary-light';
                                $icon_bg = ($m['is_read'] == 0) ? 'bg-white' : 'bg-light';
                            ?>

                            <div class="accordion-item radius-8 mb-16 border-0 overflow-hidden <?php echo $bg_class; ?>">
                                <h2 class="accordion-header" id="heading<?php echo $m['id']; ?>">
                                    <button class="accordion-button collapsed bg-transparent shadow-none d-flex flex-wrap align-items-center gap-3" type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo $m['id']; ?>">
                                        
                                        <div class="w-40-px h-40-px <?php echo $icon_bg; ?> <?php echo $icon_color; ?> rounded-circle d-flex justify-content-center align-items-center flex-shrink-0 shadow-sm">
                                            <?php if($m['is_replied'] == 1): ?>
                                                <iconify-icon icon="solar:check-circle-bold" class="text-success-main text-xl"></iconify-icon> <?php elseif($m['is_read'] == 0): ?>
                                                <iconify-icon icon="solar:letter-unread-bold" class="text-xl"></iconify-icon> <?php else: ?>
                                                <iconify-icon icon="solar:letter-opened-linear" class="text-xl"></iconify-icon> <?php endif; ?>
                                        </div>

                                        <div class="d-flex flex-column flex-grow-1">
                                            <div class="d-flex align-items-center gap-2">
                                                <span class="text-md <?php echo $text_weight; ?>"><?php echo htmlspecialchars($m['name']); ?></span>
                                                
                                                <?php if($m['is_read'] == 0): ?>
                                                    <span class="badge bg-danger-focus text-danger-main text-xs px-2 py-1 radius-4">YENİ</span>
                                                <?php endif; ?>
                                                
                                                <?php if($m['is_replied'] == 1): ?>
                                                    <span class="badge bg-success-focus text-success-main text-xs px-2 py-1 radius-4">YANITLANDI</span>
                                                <?php endif; ?>
                                            </div>
                                            <span class="text-xs text-secondary-light"><?php echo htmlspecialchars($m['subject']); ?></span>
                                        </div>

                                        <div class="text-end ps-3">
                                            <span class="text-xs text-secondary-light d-block"><?php echo date("d.m.Y", strtotime($m['created_at'])); ?></span>
                                            <span class="text-xs text-secondary-light d-block"><?php echo date("H:i", strtotime($m['created_at'])); ?></span>
                                        </div>

                                    </button>
                               </h2>
                                <div id="collapse<?php echo $m['id']; ?>" class="accordion-collapse collapse" data-bs-parent="#messageList">
                                    <div class="accordion-body text-secondary-light text-sm pt-0 border-top bg-white">
                                        
                                        <div class="d-flex justify-content-end gap-2 py-3 border-bottom mb-3">
                                            
                                            <?php if($m['is_read'] == 1): ?>
                                                <a href="?action=mark_unread&id=<?php echo $m['id']; ?>" class="btn btn-outline-secondary px-3 py-1 text-xs radius-4" title="Okunmadı olarak işaretle">
                                                    Okunmadı Yap
                                                </a>
                                            <?php else: ?>
                                                <a href="?action=mark_read&id=<?php echo $m['id']; ?>" class="btn btn-outline-primary px-3 py-1 text-xs radius-4">
                                                    <iconify-icon icon="solar:check-read-linear" class="vertical-middle"></iconify-icon> Okundu Say
                                                </a>
                                            <?php endif; ?>

                                            <?php if($m['is_replied'] == 0): ?>
                                                <a href="?action=mark_replied&id=<?php echo $m['id']; ?>" class="btn btn-outline-success px-3 py-1 text-xs radius-4">
                                                    <iconify-icon icon="solar:check-circle-linear" class="vertical-middle"></iconify-icon> Yanıtlandı İşaretle
                                                </a>
                                            <?php endif; ?>
                                        </div>

                                        <div class="p-3 bg-light radius-8">
                                            <div class="d-flex align-items-center gap-2 mb-2">
                                                <iconify-icon icon="solar:user-circle-outline" class="text-lg"></iconify-icon>
                                                <strong>E-Posta:</strong> 
                                                <a href="mailto:<?php echo $m['email']; ?>" class="text-primary-600 hover-text-decoration-underline fw-medium"><?php echo $m['email']; ?></a>
                                            </div>
                                            <p class="mb-0 text-dark" style="white-space: pre-wrap;"><?php echo htmlspecialchars($m['message']); ?></p>
                                        </div>

                                        <div class="mt-3 d-flex justify-content-end gap-2">
                                            <a href="mailto:<?php echo $m['email']; ?>?subject=RE: <?php echo htmlspecialchars($m['subject']); ?>" class="btn btn-primary px-4 py-2 radius-8 text-sm d-flex align-items-center gap-2">
                                                <iconify-icon icon="solar:reply-outline" class="text-lg"></iconify-icon> Yanıtla
                                            </a>
                                            
                                            <a href="?del=<?php echo $m['id']; ?>" onclick="return confirm('Bu mesajı silmek istediğinize emin misiniz?')" class="btn btn-danger px-4 py-2 radius-8 text-sm d-flex align-items-center gap-2">
                                                <iconify-icon icon="mingcute:delete-2-line" class="text-lg"></iconify-icon> Sil
                                            </a>
                                        </div>

                                    </div>
                                </div>
                            </div>

                            <?php endforeach; ?>
                        <?php else: ?>
                            <div class="alert alert-secondary text-center py-4 border-0 radius-8">
                                <iconify-icon icon="solar:inbox-line" class="text-4xl mb-2 d-block"></iconify-icon>
                                Gelen kutusu boş.
                            </div>
                        <?php endif; ?>
                    </div>

                </div>
            </div>
        </div>
        <?php include 'inc/copyright.php'; ?>
    </main>
    <?php include 'inc/footer.php'; ?>
</body>
</html>