<?php
session_start();
require_once 'system/db.php';

// Güvenlik
if (!isset($_SESSION['is_logged_in']) || $_SESSION['is_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

// ETİKET EKLEME
if (isset($_POST['add_tag'])) {
    $name = trim($_POST['name']);
    if (!empty($name)) {
        // Aynı isimde var mı kontrol et
        $check = $db->prepare("SELECT id FROM blog_tags WHERE name = ?");
        $check->execute([$name]);
        
        if($check->rowCount() > 0){
             echo "<script>alert('Bu etiket zaten var!');</script>";
        } else {
            $stmt = $db->prepare("INSERT INTO blog_tags (name) VALUES (?)");
            $stmt->execute([$name]);
        }
    }
}

// ETİKET SİLME
if (isset($_GET['del'])) {
    $id = intval($_GET['del']);
    // İlişki tablosundan da sil (Yazılardan düşsün)
    $db->query("DELETE FROM blog_post_tags WHERE tag_id = $id");
    $db->query("DELETE FROM blog_tags WHERE id = $id");
    header("Location: blog-tags.php");
    exit;
}

// LİSTELE
$tags = $db->query("SELECT * FROM blog_tags ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="tr" data-theme="light">
<?php include 'inc/header.php'; ?>
<body>
    <?php include 'inc/sidebar.php'; ?>
    <main class="dashboard-main">
        <?php include 'inc/navbar.php'; ?>
        
        <div class="dashboard-main-body">
            <div class="d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
                <h6 class="fw-semibold mb-0">Etiket Yönetimi</h6>
                <a href="blogs.php" class="btn btn-outline-primary px-4 py-2 radius-8">
                    <iconify-icon icon="solar:arrow-left-outline" class="vertical-middle"></iconify-icon> Yazılara Dön
                </a>
            </div>

            <div class="row gy-4">
                <div class="col-lg-4">
                    <div class="card h-100 p-0 radius-12">
                        <div class="card-header border-bottom bg-base py-16 px-24">
                            <h6 class="text-lg fw-semibold mb-0">Yeni Etiket Ekle</h6>
                        </div>
                        <div class="card-body p-24">
                            <form action="" method="POST">
                                <input type="hidden" name="add_tag" value="1">
                                <div class="mb-3">
                                    <label class="form-label fw-semibold">Etiket Adı</label>
                                    <div class="input-group">
                                        <span class="input-group-text bg-base">#</span>
                                        <input type="text" name="name" class="form-control" placeholder="Örn: teknoloji" required>
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-primary w-100 radius-8">Ekle</button>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="col-lg-8">
                    <div class="card h-100 p-0 radius-12">
                        <div class="card-header border-bottom bg-base py-16 px-24">
                            <h6 class="text-lg fw-semibold mb-0">Mevcut Etiketler</h6>
                        </div>
                        <div class="card-body p-24">
                            <?php if(count($tags) > 0): ?>
                                <div class="d-flex flex-wrap gap-2">
                                    <?php foreach($tags as $t): ?>
                                    <div class="badge bg-transparent border border-gray-200 text-secondary-light px-3 py-2 radius-8 d-flex align-items-center gap-2">
                                        <span class="text-md">#<?php echo htmlspecialchars($t['name']); ?></span>
                                        <a href="?del=<?php echo $t['id']; ?>" onclick="return confirm('Silmek istiyor musunuz?')" class="text-danger-main hover-text-danger">
                                            <iconify-icon icon="mingcute:close-line" class="text-lg"></iconify-icon>
                                        </a>
                                    </div>
                                    <?php endforeach; ?>
                                </div>
                            <?php else: ?>
                                <p class="text-secondary-light text-center">Henüz etiket eklenmemiş.</p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

        </div>
        <?php include 'inc/copyright.php'; ?>
    </main>
    <?php include 'inc/footer.php'; ?>
</body>
</html>